/*======================================================================
 * CGALIB version 2
 * Screen utilities header. Contains definitions of functions in the
 * Screen Data Handling Module that are used internally by the Screen
 * Hardware Handling Modules.
 *
 * Released as Public Domain by Damian Gareth Walker, 2022.
 * Created 06-Dec-2022.
 */

/* types defined in this file */
typedef struct displaylist DisplayList;
typedef struct superscreen SuperScreen;

#ifndef __SCREEN_U_H__
#define __SCREEN_U_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * @struct displaylist
 * A linked list containing coordinates to be updated.
 */
struct displaylist {
    int x, /* x coordinate to update */
	y, /* y coordinate to update */
	w, /* width to update */
	h, /* height to update */
	id; /* the list ID of this update */
    DisplayList *next; /* next entry in display list */
};

/**
 * @struct superscreen
 * A partial Screen structure to allow hardware modules access to data
 * handling methods of a "superclass". This allows, e.g. the screen
 * hardware handler module's destroy() method to call the screen data
 * handlier module's destroy() method instead of duplicating its code.
 */
struct superscreen {
    int count; /* how many screens exist? */
    void (*destroy) (Screen *screen);
    void (*show) (Screen *screen);
    void (*hide) (Screen *screen);
    void (*update) (Screen *screen);
    void (*palette) (Screen *screen, int foreground, int background);
};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Create a new screen object and initialise its data.
 * @param  mode    The CGA screen mode: 4, 5, or 6.
 * @param  isshown 1 to show the screen on creation, 0 not to do so.
 * @return         The new screen.
 */
Screen *cgalib_init (int mode, int isshown);

/**
 * Clear the display list without updating the display.
 */
void cgalib_clear_dl (void);

/**
 * Add a screen area to the display list (areas to be updated).
 * @param screen The screen we should be showing.
 * @param x      The x coordinate of the area.
 * @param y      The y coordinate of the area.
 * @param w      The width of the area.
 * @param h      The height of the area.
 */
void cgalib_update_dl
(Screen *screen, int x, int y, int w, int h);

/**
 * Get the start of the display list.
 * @return The start of the display list.
 */
DisplayList *cgalib_get_dl (void);

# endif
