/*======================================================================
 * CGALIB version 2
 * x11 wrapper header.
 *
 * Released as Public Domain by Damian Gareth Walker, 2022.
 * Created 18-Jan-2024.
 */

#ifndef __CGA_X11_H__
#define __CGA_X11_H__

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Initialise X11 and open a window.
 */
void cgalib_x11_init (void);

/**
 * Close X11.
 */
void cgalib_x11_close (void);

/**
 * Check status.
 * @return 1 if X is initialised, 0 if not.
 */
int cgalib_x11_status (void);

/**
 * Plot a pixel in a given colour.
 * @param x The x coordinate of the pixel.
 * @param y The y coordinate of the pixel.
 * @param c The 2-bit colour value of the pixel.
 */
void cgalib_x11_plot (int x, int y, int c);

/**
 * Force a screen update.
 */
void cgalib_x11_update (void);

/**
 * Change the CGA palette.
 * @param inforeground The foresground palette.
 * @param inbackground The background colour.
 */
void cgalib_x11_palette (int inforeground, int inbackground);

/**
 * Process an X11 event and return any keyboard events.
 * @return A PC/XT compatible scan code value.
 */
int cgalib_x11_event (void);

#endif
