/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 *
 * Skill Handling Header
 */

/* Skill type definition */
typedef struct skill Skill;

#ifndef __SKILL_H__
#define __SKILL_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * @enum SkillId
 * A list of Id codes one per skill.
 */
typedef enum {
    SKILL_NONE,
    SKILL_MEDICINE,
    SKILL_STEALTH,
    SKILL_HEAVY,
    SKILL_LIGHT,
    SKILL_BLADE,
    SKILL_UNARMED
} SkillId;

/** @const SKILL_PLAYER A synonym for the first player skill. */
#define SKILL_PLAYER SKILL_MEDICINE

/**
 * @struct skill
 * A skill possessed by the player.
 */
struct skill {

    /*
     * Attributes.
     */

    /** @var id The id of the skill. */
    int id;

    /** @var level The level of skill attained. */
    int level;

    /*
     * Methods.
     */

    /**
     * Destroy a skill when no longer needed.
     * @param skill The skill to destroy.
     */
    void (*destroy) (Skill *skill);

    /**
     * Write the skill to an open file.
     * @param skill  The skill object.
     * @param output The output file handle.
     * @return       1 on success, 0 on failure.
     */
    int (*write) (Skill *skill, FILE *output);

    /**
     * Read the skill from an open file.
     * @param skill The skill object.
     * @param input The input file handle.
     * @return      1 on the success, 0 on failure.
     */
    int (*read) (Skill *skill, FILE *input);

    /**
     * Return the name of a skill.
     * @param skill The skill to name.
     */
    char *(*name) (Skill *skill);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Constructor for a skill.
 * @return The new skill.
 */
Skill *new_Skill (void);

#endif
