/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 17-Aug-2020.
 *
 * Item Module.
 */

/*----------------------------------------------------------------------
 * Required Headers.
 */

/* standard C headers */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* project headers */
#include "item.h"

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/** @var itemnames The names of the items. */
static char *item_names[] = {
    "",
    "Laser Rifle",
    "Laser Pistol",
    "Blade",
    "Helmet",
    "Body Armour",
    "Medikit",
    "Data Card"
};

/*----------------------------------------------------------------------
 * Top Level Function Definitions.
 */

/**
 * Return an item name.
 * @param id The item ID.
 */
char *item_name (int id)
{
    return item_names[id];
}
