/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 20-Jun-2024
 *
 * Beta Test Handler Module.
 */

/*----------------------------------------------------------------------
 * Included Headers.
 */

/* standard C headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* project headers */
#include "fatal.h"

/*----------------------------------------------------------------------
 * Public Functions.
 */

/**
 * Check that this beta test version has not expired.
 */
void beta_check (void)
{
    time_t rawtime; /* current time in raw format */
    struct tm *strtime; /* current time in struct tm format */
    char date[10]; /* current date as a string */

    /* check that beta is not expired */
    time (&rawtime);
    strtime = localtime (&rawtime);
    date[8] = '\0'; /* strftime doesn't terminate */
    strftime (date, 9, "%Y%m%d", strtime);
    if (strcmp (date, "20240714") > 0)
	fatal_error (FATAL_EXPIRED);
}
