/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 16-Aug-2020.
 *
 * Game Controls Header
 */

/* Controls type definition */
typedef struct controls Controls;

#ifndef __CONTROLS_H__
#define __CONTROLS_H__

/* required headers */
#include "keyboard.h"

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/** 
 * @struct controls
 * The game controls.
 */
struct controls {

    /*
     * Attributes
     */

    /** @var left 1 if left pressed at last poll, 0 otherwise. */
    int left;

    /** @var right 1 if right pressed at last poll, 0 otherwise. */
    int right;

    /** @var up 1 if up pressed at last poll, 0 otherwise. */
    int up;

    /** @var down 1 if down pressed at last poll, 0 otherwise. */
    int down;

    /** @var fire 1 if fire pressed at last poll, 0 otherwise. */
    int fire;

    /** @var ascii ASCII value of last key pressed. */
    int ascii;

    /*
     * Methods
     */

    /**
     * Destroy the keyboard handler when it is no longer needed.
     */
    void (*destroy) (void);

    /**
     * Expose the KeyHandler for other libraries that need it.
     * @return A pointer to the KeyHandler object.
     */
    KeyHandler *(*getkeyhandler) (void);

    /**
     * Wait for a key down event, and update the attributes.
     * @param msecs Number of milliseconds to wait, 0 forever.
     */
    void (*wait) (int msecs);

    /**
     * Wait for a key release or repeat delay.
     * @param msecs Number of milliseconds to wait, 0 forever.
     */
    void (*release) (int msecs);

    /**
     * Poll the keyboard and update the attributes.
     */
    void (*poll) (void);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Construct new game controls handler.
 * @return The new game controls handler.
 */
Controls *new_Controls (void);

#endif
