/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 17-Aug-2020.
 *
 * Cabinet Header.
 */

/* types defined by this header */
typedef struct cabinet Cabinet;

#ifndef __CABINET_H__
#define __CABINET_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * @struct cabinet
 * A cabinet of items on the ground or in a cabinet.
 */
struct cabinet {

    /*
     * Attributes
     */

    /** @var items An array of items on the cabinet. */
    int items[12];

    /** @var x X coordinate of the cabinet on the level map. */
    int x;

    /** @var y Y coordinate of the cabinet on the level map. */
    int y;

    /*
     * Methods
     */

    /**
     * Destroy the cabinet.
     * @param cabinet The cabinet object.
     */
    void (*destroy) (Cabinet *cabinet);

    /**
     * Write the cabinet to an open file.
     * @param cabinet  The cabinet object.
     * @param output The output file handle.
     * @return       1 on success, 0 on failure.
     */
    int (*write) (Cabinet *cabinet, FILE *output);

    /**
     * Read the cabinet from an open file.
     * @param cabinet The cabinet object.
     * @param input The input file handle.
     * @return      1 on the success, 0 on failure.
     */
    int (*read) (Cabinet *cabinet, FILE *input);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Create a new cabinet of items.
 * @return The new cabinet.
 */
Cabinet *new_Cabinet (void);

#endif
