// =====================================================================
// Star Cadre: Combat Class
// A single-level tactical combat game.
//
// Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
// Created: 06-Jun-2024.
//
// Medikit definition.
//


// Medikit box base
#declare MedikitBoxBase =
difference {
  box {
    <-10, -10, -10>,
    <10, 5, 10>
  }
  box {
    <-9.5, -9.5, -9.5>,
    <9.5, 9.5, 9.5>
  }
  texture {
    pigment { color White }
  }
}

// Medikit box seal
#declare MedikitBoxSeal =
difference {
  box {
    <-9.75, 5, -9.75>
    <9.75, 5.5, 9.75>
  }
  box {
    <-9.5, -9.5, -9.5>,
    <9.5, 9.5, 9.5>
  }
  texture {
    pigment { color Cyan }
  }
}

// Medikit H
#declare MedikitH =
union {
  box {
    <-1.5, -1.5, -0.25>,
    <-0.5, 1.5, 0.25>
  }
  box {
    <-1.5, -0.5, -0.25>,
    <1.5, 0.5, 0.25>
  }
  box {
    <0.5, -1.5, -0.25>,
    <1.5, 1.5, 0.25>
  }
  scale <2, 2, 2>
  texture {
    pigment { color Red }
  }
}

// Medikit box lid
#declare MedikitBoxLid =
union {
  difference {
    box {
      <-10, 5.5, -10>,
      <10, 10, 10>
    }
    box {
      <-9.5, -9.5, -9.5>,
      <9.5, 9.5, 9.5>
    }
    box {
      <-10.5, 10.5, -10.5>,
      <10.5, 9.5, -9.5>
    }
    box {
      <-10.5, 10.5, -10.5>,
      <-9.5, 9.5, 10.5>
    }
    box {
      <10.5, 10.5, -10.5>,
      <9.5, 9.5, 10.5>
    }
    box {
      <-10.5, 10.5, 10.5>,
      <10.5, 9.5, 9.5>
    }
  }
  cylinder {
    <-9.5, 9.5, -9.5>
    <9.5, 9.5, -9.5>
    0.5
  }
  cylinder {
    <-9.5, 9.5, -9.5>
    <-9.5, 9.5, 9.5>
    0.5
  }
  cylinder {
    <9.5, 9.5, -9.5>
    <9.5, 9.5, 9.5>
    0.5
  }
  cylinder {
    <-9.5, 9.5, 9.5>
    <9.5, 9.5, 9.5>
    0.5
  }
  sphere {
    <-9.5, 9.5, -9.5>,
    0.5
  }
  sphere {
    <-9.5, 9.5, 9.5>,
    0.5
  }
  sphere {
    <9.5, 9.5, -9.5>,
    0.5
  }
  sphere {
    <9.5, 9.5, 9.5>,
    0.5
  }
  texture {
    pigment { color White }
  }
}

// Medikit base
#declare MedikitBase =
union {
  object { MedikitBoxBase }
  object { MedikitBoxSeal }
  object {
    MedikitH
    translate <0, 0, -10>
  }
}

// Medikit Clasp
#declare MedikitClasp =
union {
  box {
    <-2, 4, -0.25>,
    <2, 6.5, 0.25>
  }
  box {
    <-1, 4.5, -2>,
    <1, 6, 0.25>
  }
  translate <0, 0, -10>
  texture {
    pigment { color Gray }
  }
}

// Medikit Lid
#declare MedikitLid =
union {
  object { MedikitBoxLid }
  object {
    MedikitH
    rotate <90, 0, 0>
    translate <0, 10, 0>
  }
}

// Main medikit object
#declare Medikit =
union {
  object { MedikitBase }
  object { MedikitClasp }
  object { MedikitLid }
  translate <0, 10, 0>
}