// =====================================================================
// Star Cadre: Combat Class
// A single-level tactical combat game.
//
// Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
// Created: 06-Jun-2024.
//
// Helmet definition.
//

// Main helmet shape
#declare HelmetShell =
difference {
  union {
    sphere {
      <0, 0, 0>, 15
    }
    cone {
      <0, 0, 0>, 15
      <0, -15, 0>, 10
    }
    texture {
      pigment { color Cyan }
    }
  }
  union {
    sphere {
      <0, 0, 0>, 14.5
    }
    cone {
      <0, 0, 0>, 14.5
      <0, -15, 0>, 9.5
    }
    cylinder {
      <0, 0, 0>,
      <0, -16, 0>,
      9.5
    }
    sphere {
      <0, 0, -15>, 10
      scale <1, 0.5, 1>
    }
    cylinder {
      <0, 0, -15>,
      <0, -16, -15>,
      10
    }
  }
}

// Helmet insignia
#declare HelmetInsignia =
union {
  cylinder {
    <0, 0, 0.5>,
    <0, 0, -0.5>
    1
  }
  torus {
    2, 0.25
    rotate <90, 0, 0>
    scale <1, 0.25, 1>
  }
  texture {
    pigment { color Red }
  }
  translate <0, 0, -15>
  rotate <45, 0, 0>
}

// Helmet Antenna
#declare HelmetAntenna =
union {
  cylinder {
    <14.5, 0, 0>,
    <15.5, 0, 0>,
    2
    texture {
      pigment { color Red }
    }
  }
  cylinder {
    <15, 0, 0>,
    <15, 10, 0>,
    0.25
    texture {
      pigment { color White }
    }
  }
  sphere {
    <15, 10, 0>,
    0.5
    texture {
      pigment { color Red }
    }
  }
}

// Helmet Visor
#declare HelmetVisor =
difference {
  union {
    sphere {
      <0, 0, 0>, 10
      scale <1, 0.5, 0.25>
    }
    cylinder {
      <0, 0, 0>,
      <0, -5, 0>,
      10
      scale <1, 1, 0.25>
    }
  }
  union {
    sphere {
      <0, 0, 0>, 9.5
      scale <1, 0.5, 0.25>
    }
    cylinder {
      <0, 0, 0>,
      <0, -5, 0>,
      9.5
      scale <1, 1, 0.25>
    }
    box {
      <-10, -10, 0>,
      <10, 10, 5>
    }
  }
  translate <0, 0, -12>
  texture {
    pigment {
      color rgbf <1, 1, 1, 0.875>
    }
  }
}

// Main helmet object
#declare Helmet =
union {
  object { HelmetShell }
  object { HelmetInsignia }
  object { HelmetAntenna }
  object { HelmetVisor }
  translate <0, 15, 0>
}