/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 17-Aug-2020.
 *
 * Item Header.
 */

#ifndef __ITEM_H__
#define __ITEM_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/** @enum itemid The item IDs. */
typedef enum itemid {
    ITEM_NONE,
    ITEM_RIFLE, /* laser rifle */
    ITEM_PISTOL, /* laser pistol */
    ITEM_BLADE, /* blade */
    ITEM_HELMET, /* helmet */
    ITEM_ARMOUR, /* body armour */
    ITEM_MEDIKIT, /* medikit */
    ITEM_CARD, /* data card */
    ITEM_COUNT /* number of items including "none" */
} ItemId;

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Return an item name.
 * @param id The item ID.
 */
char *item_name (int id);

#endif
