/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2024. Released under the GNU GPL.
 * Created: 30-May-2024.
 *
 * Config Header.
 */

/* types defined in this header */
typedef struct config Config;

#ifndef __CONFIG_H__
#define __CONFIG_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * enum TutorialID
 * IDs of each of the tutorial messages.
 */
typedef enum {
    TUTORIAL_DEPLOY,
    TUTORIAL_MOVE,
    TUTORIAL_LEAVE,
    TUTORIAL_NEXTUNIT
} TutorialID;

/**
 * @struct config
 * The high score table.
 */
struct config {

    /*
     * Attributes
     */

    /** @var level Difficulty level. */
    int level;

    /** @var type Mission type. */
    int type;

    /** @var classes Player team unit classes. */
    int classes[4];

    /** @var tutorial Bitfield for tutorials shown. */
    int tutorial;

    /*
     * Methods
     */

    /**
     * Destroy the score table object.
     * @param config The score table object.
     */
    void (*destroy) (Config *config);

    /**
     * Save the high score table.
     * @param config The score table object.
     * @return       1 if successful, 0 if not.
     */
    int (*save) (Config *config);

    /**
     * Load the high score table. If there is no valid high score
     * table file, initialise all the config to zero.
     * @param config The score table object.
     * @return       1 if successfully loaded, 0 if not.
     */
    int (*load) (Config *config);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Create the score table object.
 * @return The new score table object.
 */
Config *new_Config (void);

#endif
