/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2024. Released under the GNU GPL.
 * Created: 08-May-2024.
 *
 * UI Module.
 */

/*----------------------------------------------------------------------
 * Included Headers.
 */

/* standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* project headers */
#include "ui.h"

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/** @var ui A pointer to the UI structure. */
static UI *ui;

/*----------------------------------------------------------------------
 * Public Method Function Definitions.
 */

/**
 * Initialise the UI.
 * @return   1 on success, 0 on failure.
 */
static int init (void)
{
    return 0;
}

/**
 * Operate the UI.
 * @return   1 on success, 0 on failure.
 */
static int operate (void)
{
    return 0;
}

/**
 * Destroy UI.
 */
static void destroy (void)
{
    free (ui);
    ui = NULL;
}

/*----------------------------------------------------------------------
 * Top Level Function Definitions.
 */

/**
 * Construct Generic UI.
 * @return The new AI.
 */
UI *new_UI (void)
{
    /* reserve memory for the UI */
    if (! (ui = malloc (sizeof (UI))))
	return NULL;

    /* initialise methods */
    ui->destroy = destroy;
    ui->init = init;
    ui->operate = operate;

    /* return the UI */
    return ui;
}
