/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 07-May-2024.
 *
 * Cabinet Module.
 */

/* standard C headers */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* project headers */
#include "cabinet.h"
#include "fatal.h"
#include "utils.h"

/*----------------------------------------------------------------------
 * Public Method Function Defintions.
 */

/**
 * Destroy the cabinet.
 * @param cabinet The cabinet object.
 */
static void destroy (Cabinet *cabinet)
{
    free (cabinet);
}

/**
 * Write the cabinet to an open file.
 * @param cabinet  The cabinet object.
 * @param output The output file handle.
 * @return       1 on success, 0 on failure.
 */
static int write (Cabinet *cabinet, FILE *output)
{
    int c; /* counter */
    for (c = 0; c < 12; ++c)
	if (! writeint (&cabinet->items[c], output))
	    return 0;
    if (! writeint (&cabinet->x, output))
	return 0;
    if (! writeint (&cabinet->y, output))
	return 0;
    return 1;
}

/**
 * Read the cabinet from an open file.
 * @param cabinet The cabinet object.
 * @param input The input file handle.
 * @return      1 on the success, 0 on failure.
 */
static int read (Cabinet *cabinet, FILE *input)
{
    int c; /* counter */
    for (c = 0; c < 12; ++c)
	if (! readint (&cabinet->items[c], input))
	    return 0;
    if (! readint (&cabinet->x, input))
	return 0;
    if (! readint (&cabinet->y, input))
	return 0;
    return 1;
}

/*----------------------------------------------------------------------
 * Top Level Function Definitions.
 */

/**
 * Create a new cabinet of items.
 * @return The new cabinet.
 */
Cabinet *new_Cabinet (void)
{
    Cabinet *cabinet; /* the new cabinet */
    int c; /* counter */

    /* reserve memory for the cabinet. */
    if (! (cabinet = malloc (sizeof (Cabinet))))
	fatal_error (FATAL_MEMORY);

    /* initialise the methods */
    cabinet->destroy = destroy;
    cabinet->write = write;
    cabinet->read = read;

    /* initialise the attributes */
    for (c = 0; c < 12; ++c)
	cabinet->items[c] = 0;
    cabinet->x = 0;
    cabinet->y = 0;

    /* return the new cabinet */
    return cabinet;
}
