/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2024. Released under the GNU GPL.
 * Created: 08-May-2024.
 *
 * UI Header.
 */

/* types defined in this header. */
typedef struct ui UI;

#ifndef __UI_H__
#define __UI_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * @struct ui The basic user interface.
 */
struct ui {

    /*
     * Methods
     */

    /**
     * Destroy UI.
     */
    void (*destroy) (void);

    /**
     * Initialise the UI.
     * @return   1 on success, 0 on failure.
     */
    int (*init) (void);

    /**
     * Operate the UI.
     * @return   1 on success, 0 on failure.
     */
    int (*operate) (void);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Construct Generic UI.
 * @return The new UI.
 */
UI *new_UI (void);

/**
 * Construct Map UI
 * @return The new UI.
 */
UI *new_MapUI (void);

/**
 * Construct Computer UI
 * @return The new UI.
 */
UI *new_ComputerUI (void);

/**
 * Construct Victory Screen UI.
 * @return The new UI.
 */
UI *new_VictoryUI (void);

/**
 * Construct Victory Screen UI.
 * @return The new UI.
 */
UI *new_DefeatUI (void);

/**
 * Construct Scores Screen UI.
 * @return The new UI.
 */
UI *new_ScoresUI (void);

/**
 * Construct Config Screen UI.
 * @return The new UI.
 */
UI *new_ConfigUI (void);

#endif
