/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 06-Aug-2020.
 *
 * Main Program Header.
 */

#ifndef __SCMZ_H__
#define __SCMZ_H__

/* project headers */
#include "names.h"

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/* external types */
typedef struct controls Controls;
typedef struct display Display;
typedef struct scores Scores;
typedef struct game Game;
typedef struct config Config;

/*----------------------------------------------------------------------
 * Public Level Routines.
 */

/**
 * Display progress update for game generation/loading.
 * @param unitno Unit number progress.
 */
void generateprogress (int unitno);

/**
 * Share the name generator with other modules.
 * @return A pointer to the name generator.
 */
Names *getnamegenerator (void);

/**
 * Share the control handler with other modules.
 * @return A pointer to the game control handler.
 */
Controls *getcontrols (void);

/**
 * Share the display handler with other modules.
 * @return A pointer to the display module.
 */
Display *getdisplay (void);

/**
 * Share the game handler with other modules.
 * @return A pointer to the game module.
 */
Game *getgame (void);

/**
 * Share the scores handler with other modules.
 * @return A pointer to the scores module.
 */
Scores *getscores (void);

/**
 * Share the config handler with other modules.
 * @return A pointer to the config module.
 */
Config *getconfig (void);

#endif
