// =====================================================================
// Star Corps: Mission Zero
// A single-level tactical combat game.
//
// Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
// Created: 06-Aug-2020.
//
// Title screen ray-tracing source
//

// Includes
#include "colors.inc"

// Camera
camera {
  location <0, 0, -10>
  look_at  <0, 0,  0>
  right x*144/128
}

// Planet
sphere {
  <0, 0, 12500000>, 5000000
  texture {
    pigment { color Red }
  }
}

// Spacecraft
union {
  
  // crew section
  cylinder {
    <0, 0, -1.25>
    <0, 0, 1.25>
    1
    texture {
      pigment { color White }
    }
    scale <2, 1, 1>

    // There's a weird issue which rotates all cylinders about the X
    // axis by 45 degrees, and translates them on the Z axis by
    // a value that is the negative equivalent of its radius.
    // These lines bring the cylinder back to where it should be.
    //rotate <+45 0 0>
    //translate <0 0 +1>
  }
  
  // left engine
  cylinder {
    <0, 0, -0.5>
    <2, 0, -0.5>
    0.5
    texture {
      pigment { color White }
    }

    // There's a weird issue which rotates all cylinders about the X
    // axis by 45 degrees, and translates them on the Z axis by
    // a value that is the negative equivalent of its radius.
    // These lines bring the cylinder back to where it should be.
    //rotate <+45 0 0>
    //translate <0 0 +0.5>
  }

  // right engine
  cylinder {
    <0, 0, 0.5>
    <2, 0, 0.5>
    0.5
    texture {
      pigment { color White }
    }

    // Povray has a bug which rotates all cylinders about the X
    // axis by 45 degrees, and translates them on the Z axis by
    // a value that is the negative equivalent of its radius.
    // These lines bring the cylinder back to where it should be.
    //rotate <+45 0 0>
    //translate <0 0 +0.5>
  }
  
  // crew window
  cylinder {
    <-1, 0, 0>
    <-1, 1, 0>
    1
    texture {
      pigment { color Cyan }
    }

    // Povray has a bug which rotates all cylinders about the X
    // axis by 45 degrees, and translates them on the Z axis by
    // a value that is the negative equivalent of its radius.
    // These lines bring the cylinder back to where it should be.
    //rotate <+45 0 0>
    //translate <+1 0 0>
  }
  
  // wings
  sphere {
    <0, 0, 0>
    1
    scale <1, 0.25, 4>
    texture {
      pigment { color White }
    }
  }
  
  rotate <-45, 45, 0>
}

// Light Source
global_settings { ambient_light rgb <0, 0, 0> }
light_source {
  <-10000000, +10000000, 0>
  color White
}
