/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
 * Created: 17-Aug-2020.
 *
 * Item Stack Header.
 */

/* types defined by this header */
typedef struct itemstack ItemStack;

#ifndef __STACK_H__
#define __STACK_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * @struct itemstack
 * A stack of items on the ground or in a cabinet.
 */
struct itemstack {

    /*
     * Attributes
     */

    /** @var x X coordinate of the stack on the level map. */
    int x;

    /** @var y Y coordinate of the stack on the level map. */
    int y;

    /** @var itemcount The number of items on the stack. */
    int itemcount;

    /** @var items An array of items on the stack. */
    int *items;

    /*
     * Methods
     */

    /**
     * Destroy the stack.
     * @param stack The stack object.
     */
    void (*destroy) (ItemStack *stack);

    /**
     * Write the stack to an open file.
     * @param stack  The stack object.
     * @param output The output file handle.
     * @return       1 on success, 0 on failure.
     */
    int (*write) (ItemStack *stack, FILE *output);

    /**
     * Read the stack from an open file.
     * @param stack The stack object.
     * @param input The input file handle.
     * @return      1 on the success, 0 on failure.
     */
    int (*read) (ItemStack *stack, FILE *input);

    /**
     * Add an item onto the stack.
     * @param stack The stack object.
     */
    void (*drop) (ItemStack *stack, int item);

    /**
     * Remove an item from the stack.
     * @param stack The stack object.
     * @return The item removed from the stack, or 0 for none.
     */
    int (*take) (ItemStack *stack);

    /**
     * Return the item on top of the stack.
     * @param stack The stack object.
     * @return The item on the top of the stack, or 0 for none.
     */
    int (*top) (ItemStack *stack);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Create a new stack of items.
 * @return The new stack.
 */
ItemStack *new_ItemStack (void);

#endif
