/*======================================================================
 * Star Cadre: Combat Class
 * A single-level tactical combat game.
 *
 * Copyright (C) Damian Gareth Walker 2024. Released under the GNU GPL.
 * Created: 30-May-2024.
 *
 * Score Table Header.
 */

/* types defined in this header */
typedef struct scores Scores;

#ifndef __SCORES_H__
#define __SCORES_H__

/* required headers */
#include "game.h"

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * @struct scores
 * The high score table.
 */
struct scores {

    /*
     * Attributes
     */

    /** @var scores The high score table array. */
    int scores[3][6];

    /*
     * Methods
     */

    /**
     * Destroy the score table object.
     * @param scores The score table object.
     */
    void (*destroy) (Scores *scores);

    /**
     * Save the high score table.
     * @param scores The score table object.
     * @return       1 if successful, 0 if not.
     */
    int (*save) (Scores *scores);

    /**
     * Load the high score table. If there is no valid high score
     * table file, initialise all the scores to zero.
     * @param scores The score table object.
     * @return       1 if successfully loaded, 0 if not.
     */
    int (*load) (Scores *scores);

    /**
     * Submit a score to the high score table.
     * @param scores The score table object.
     * @param game   The game object.
     * @return       1 if the score was added, 0 if not.
     */
    int (*submit) (Scores *scores, Game *game);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Create the score table object.
 * @return The new score table object.
 */
Scores *new_Scores (void);

#endif
