// =====================================================================
// Star Cadre: Combat Class
// A single-level tactical combat game.
//
// Copyright (C) Damian Gareth Walker 2020. Released under the GNU GPL.
// Created: 06-Jun-2024.
//
// Laser Pistol definition.
//

// Pistol Barrel
#declare PistolBarrel =
object {
  cylinder {
    <-7.5, 0, 0>
    <2.5, 0, 0>
    0.75
  }
  texture {
    pigment {
      color Cyan
    }
  }
}

#declare PistolMuzzle =
union {
  cylinder {
    <0, 0, 0>
    <7.5, 0, 0>
    0.25
    texture {
      pigment {
	color White
      }
    }
  }
  union {
    cylinder {
      <3.75, 0, 0>
      <3.625, 0, 0>
      0.75
    }
    cylinder {
      <5, 0, 0>
      <4.875, 0, 0>
      0.75
    }
    cylinder {
      <6.25, 0, 0>
      <6.125, 0, 0>
      0.75
    }
    texture {
      pigment {
	color rgbf <1, 0.33, 0.33, 0>
      }
    }
    finish {
      ambient <0.75, 0.75, 0.75>
    }
  }
}

#declare PistolGrip =
box {
  <-5, -0.75, 0>
  <-2.5, 0.75, -7>
  texture {
    pigment {
      color Cyan
    }
  }
}


// Main pistol shape
#declare Pistol =
union {
  object {PistolBarrel}
  object {PistolMuzzle}
  object {PistolGrip}
  scale <1.5, 1.5, 1.5>
  translate <0, 0.75, 0>
}