/*======================================================================
 * CGALIB version 2
 * Main header.
 *
 * Released as Public Domain by Damian Gareth Walker, 2022.
 * Created 06-Dec-2022.
 */

#ifndef __CGALIB_H__
#define __CGALIB_H__

/*----------------------------------------------------------------------
 * Required Headers.
 */

/* standard headers */
#include <stdio.h>

/*----------------------------------------------------------------------
 * Data Declarations.
 */

/**
 * @enum ShowMode
 * Constants for screens hidden and shown.
 */
typedef enum {
    CGALIB_HIDDEN, /* the screen remains hidden on creation */
    CGALIB_SHOWN /* the screen is shown on creation */
} ShowMode;

/**
 * @enum GraphicsMode
 * Constants for the graphics modes.
 */
typedef enum {
    CGALIB_MEDIUM = 4, /* 320x200 4-colour mode */
    CGALIB_MEDIUM_MONO, /* 320x200 4-greyscale mode */
    CGALIB_HIGH, /* 640x200 monochrome mode */
    CGALIB_HERCULES /* 720x348 Hercules mode */
} GraphicsMode;

/**
 * @enum ScreenFileFormat
 * Format for loading and saving screen files.
 */
typedef enum {
    CGALIB_BITMAP_FILE, /* a 320x200 bitmap */
    CGALIB_SCREEN_FILE /* a PC-Paint BSAVE screen file */
} ScreenFileFormat;

/**
 * @enum ForegroundID
 * Constants for the foreground palettes.
 */
typedef enum {
    CGALIB_GREEN_RED_BROWN,
    CGALIB_CYAN_MAGENTA_WHITE,
    CGALIB_CYAN_RED_WHITE,
    CGALIB_LIGHT_GREEN_RED_YELLOW,
    CGALIB_LIGHT_CYAN_MAGENTA_WHITE,
    CGALIB_LIGHT_CYAN_RED_WHITE
} ForegroundID;

/**
 * @enum BackgroundID
 * Constants for the background colours.
 */
typedef enum {
    CGALIB_BLACK,
    CGALIB_BLUE,
    CGALIB_GREEN,
    CGALIB_CYAN,
    CGALIB_RED,
    CGALIB_MAGENTA,
    CGALIB_BROWN,
    CGALIB_WHITE,
    CGALIB_GREY,
    CGALIB_LIGHT_BLUE,
    CGALIB_LIGHT_GREEN,
    CGALIB_LIGHT_CYAN,
    CGALIB_LIGHT_RED,
    CGALIB_LIGHT_MAGENTA,
    CGALIB_YELLOW,
    CGALIB_WHITE_HIGH
} BackgroundID;

/**
 * @enum InkID
 * Constants for the four ink colours.
 */
typedef enum {
    CGALIB_INK_BACKGROUND = 0,
    CGALIB_INK_GREEN = 1, /* in foreground palettes 0, 3 */
    CGALIB_INK_CYAN = 1, /* in foreground palettes 1, 2, 4, 5 */
    CGALIB_INK_RED = 2, /* in foreground palettes 0, 2, 3, 5 */
    CGALIB_INK_MAGENTA = 2, /* in foreground palettes 1, 4 */
    CGALIB_INK_BROWN = 3, /* in foreground palette 0 */
    CGALIB_INK_WHITE = 3, /* in foreground paletts 1, 2, 4, 5 */
    CGALIB_INK_YELLOW = 3 /* in foreground palette 3 */
} InkID;

/**
 * @enum PaperID
 * Constants for the four paper colours.
 */
typedef enum {
    CGALIB_PAPER_BACKGROUND = 0,
    CGALIB_PAPER_GREEN = 1, /* in foreground palettes 0, 3 */
    CGALIB_PAPER_CYAN = 1, /* in foreground palettes 1, 2, 4, 5 */
    CGALIB_PAPER_RED = 2, /* in foreground palettes 0, 2, 3, 5 */
    CGALIB_PAPER_MAGENTA = 2, /* in foreground palettes 1, 4 */
    CGALIB_PAPER_BROWN = 3, /* in foreground palette 0 */
    CGALIB_PAPER_WHITE = 3, /* in foreground paletts 1, 2, 4, 5 */
    CGALIB_PAPER_YELLOW = 3 /* in foreground palette 3 */
} PaperID;

/**
 * @enum DrawMode
 * The different draw modes for transfer and put operations.
 */
typedef enum {
    CGALIB_SET, /* imprint all the pixels of the bitmap */
    CGALIB_RESET, /* imprint a negative of all the pixels of the bitmap */
    CGALIB_AND, /* AND the pixels with the ones from the bitmap */
    CGALIB_OR, /* OR the pixels with the ones from the bitmap */
    CGALIB_XOR /* Exclusive OR the pixels with the ones from the bitmap */
} DrawMode;

/**
 * @enum BoxPattern
 * Some useful box patterns
 */
#define CGALIB_BOX_BLANK 0x0000
#define CGALIB_BOX_FILLED 0xffff
#define CGALIB_BOX_DITHERED 0xcc33
#define CGALIB_BOX_VSTRIPED 0x3333
#define CGALIB_BOX_HSTRIPED 0xff00

/* included headers */
#include "screen.h"
#include "bitmap.h"
#include "font.h"
#include "keyboard.h"
#include "speaker.h"

#endif
