//======================================================================
// Pym's Daily Word Square Puzzle.
// A puzzle game for MS-DOS.
//
// Copyright (C) Thomas A. Fine, 2004
// Adapted: 01-Nov-2024 by Damian Gareth Walker
//
// Fabric Texture for Book Cover
//

// H_streaks and V_streaks are used to make natural looking fiber streaks
// for the fabric
#declare H_streaks = pigment {
  bozo color_map {
    [0.2 color rgb <0.4, 0.3, 0.2>]
    [0.8 color rgb <0.9, 0.8, 0.7>]
  } scale <10, 0.1, 1>
}
#declare V_streaks = pigment {
  bozo color_map {
    [0.2 color rgb <0.4, 0.3, 0.2>]
    [0.8 color rgb <0.9, 0.8, 0.7>]
  } scale <0.1, 10, 1>
}

// A fabric bump map is used to shade the surface (see fabricbumps.pov)
// Then, a checkerboard is overlayed using alternating patterns of H_streaks
// and V_streaks.  The checker pattern and the bump map
// are scaled together so that the streaks line up with the fiber bumps.
#declare fabric = texture {
  pigment {
    checker pigment { H_streaks }
    pigment { V_streaks }
    scale 0.5*0.17
  }
  normal {
    bump_map {
      gif "fabric.gif"
      bump_size 10
    }
    scale 0.17
  }
  finish {
    diffuse 0.8
    specular 0.2
  }
}
