#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

static char mysquare[25],
    yoursquare[25],
    *allsquares[] =
{
    "burst/urine/rifer/sneer/terry",
    "lasts/apart/satay/trace/styes",
    "admit/drone/modal/inane/telex",
    "farts/ashen/rhino/tenor/snort",
    "score/carom/orate/rotor/emery",
    "tense/edema/never/smell/early",
    "dared/alive/riven/evens/dense",
    "chafe/helix/aline/finer/exert",
    "vaped/aurae/prose/eased/deeds",
    "layer/alone/yokel/enema/relay",
    "scant/cower/aware/nerve/trees",
    "rages/anode/gorge/edger/seers",
    "cusps/uteri/semis/price/sises",
    "aspen/share/paves/erect/nests",
    "spasm/poppa/apron/spots/manse",
    "butch/uvula/tutor/clove/hares",
    "paves/awake/valid/eking/sedge",
    "meter/erode/toner/edema/reran",
    "bated/alone/towel/enema/delay",
    "atria/teens/recap/inane/aspen",
    "halls/avian/lingo/lager/snore",
    "rebut/erase/baser/users/terse",
    "canes/anode/noted/edema/sedan",
    "bands/abort/novae/drain/stent",
    "holed/ozone/loyal/enact/delta",
    "views/islet/elide/wedge/steer",
    "realm/emcee/acmes/leers/messy",
    "yeast/enema/aegis/smite/taser",
    "baker/agile/kinda/elder/rears",
    "halts/aloha/lower/these/saree",
    "khans/halon/alive/novae/sneer",
    "harks/atone/rowel/knell/sells",
    "plush/ladle/udder/slept/hertz",
    "cacao/aping/civil/anise/ogled",
    "hurls/usual/rusty/lathe/slyer",
    "crabs/remit/ample/bilge/steel",
    "feted/erode/toxin/edits/dense",
    "coons/owlet/olive/never/stern",
    "silos/inapt/laxer/opera/strap",
    "jabot/above/bones/overt/testy",
    "lands/abort/novae/drama/steal",
    "basic/aside/sibyl/idyll/cello",
    "pacts/arrow/crane/tonne/sweet",
    "upped/pease/paste/ester/deers",
    "tears/enrol/argue/rouse/sleet",
    "facts/adore/cozen/tress/sense",
    "caret/afire/rimes/erect/testy",
    "bombs/overt/media/briar/stare",
    "ogles/glint/liker/enema/strap",
    "tarps/abort/rogue/prude/steep",
    "moths/ocean/tense/haste/sneer",
    "ashen/spare/hazes/erect/nests",
    "blots/lithe/other/there/serer",
    "galls/await/later/liege/strew",
    "serer/erode/rosin/edict/rents",
    "solar/olive/liras/avast/rests",
    "gates/agent/tease/ensue/steel",
    "noted/opine/titan/enact/dents",
    "scabs/cabal/abate/bathe/sleet",
    "madam/abode/dogma/adman/means",
    "ramps/aloha/molar/phase/saree",
    "naval/anime/vixen/amend/lends",
    "slats/light/agree/there/steer",
    "users/sleep/eerie/reign/spend",
    "weals/endue/adore/lurid/seeds",
    "cliff/loner/inane/fence/frees",
    "sager/atone/goons/ennui/resin",
    "chapt/huger/agile/pelts/tress",
    "pilaw/inane/labia/anion/weans",
    "stamp/total/atone/manna/pleat",
    "salts/alarm/labia/trips/smash",
    "shelf/honor/ennui/louse/fries",
    "chasm/hippo/aphid/spite/model",
    "rices/inane/caged/enema/sedan",
    "bides/inert/decor/erode/strep",
    "calif/amino/liver/inept/forts",
    "daubs/asset/usage/begun/stent",
    "hewed/exile/widen/elect/dents",
    "posts/opera/seven/trend/sandy",
    "hasps/annul/snore/puree/sleek",
    "rodeo/opera/debar/erase/oared",
    "dealt/eyrie/aroma/limos/tease",
    "wasps/apple/spoon/ploys/sense",
    "plate/laden/adept/tepee/enter",
    "harsh/agape/razor/sport/hertz",
    "label/abide/binge/edger/leery",
    "garbs/aware/rayon/brows/sense",
    "laces/aware/carom/erode/semen",
    "tabus/azure/bulge/urged/seedy",
    "iotas/ochre/throw/arose/sewed",
    "cavil/amino/video/inept/loots",
    "mamma/alias/mints/matte/asset",
    "hasty/aware/sagas/trade/yeses",
    "trams/roman/amino/mango/snoot",
    "femur/elate/maced/uteri/redid",
    "hared/atone/roman/enact/dents",
    "spelt/paler/elude/ledge/trees",
    "wager/anime/given/emend/rends",
    "parts/apart/ratio/trial/stole",
    "games/axial/micra/earns/slash",
    "pales/amino/liken/enema/sonar",
    "reset/ether/share/eerie/treed",
    "thugs/hovel/uvula/gelds/slash",
    "later/afire/tides/erect/rests",
    "rarer/afire/rises/erect/rests",
    "boast/owner/ankle/sells/tress",
    "pasha/attar/start/harps/artsy",
    "steps/tulip/elite/piton/spent",
    "franc/rower/aware/nerds/crest",
    "panes/agent/newer/enema/stray",
    "crumb/rotor/uteri/moron/brink",
    "grams/robot/above/movie/steer",
    "stats/togae/agape/taped/seedy",
    "jocks/ozone/cozen/kneed/sends",
    "liars/islet/alive/revue/steel",
    "nests/extol/stone/tonne/sleek",
    "nodal/opera/denim/arise/lamer",
    "ebbed/blade/badge/edged/deeds",
    "balks/aline/linen/knead/sends",
    "sates/axial/tinge/eagle/sleet",
    "aster/sauna/tubed/enema/radar",
    "carat/ameba/regal/abate/tales",
    "besot/extra/steal/orate/tales",
    "meals/egret/array/lease/styes",
    "spans/pilot/alive/novae/steer",
    "capes/aisle/pshaw/elate/sewed",
    "truss/retch/utter/scene/shred",
    "flaps/label/abaci/pecan/slink",
    "chest/hunch/entry/scram/thymi",
    "papal/ameba/penis/abide/laser",
    "quaff/uteri/aerie/frier/fiery",
    "vases/arena/serum/enure/sames",
    "babes/aline/bided/enema/sedan",
    "leaps/exult/augur/plume/strep",
    "paths/afoot/toque/house/steer",
    "sames/aline/mimed/enema/sedan",
    "rabid/aside/bible/idler/deers",
    "grasp/roger/agree/seeps/press",
    "glued/liter/uteri/eerie/drier",
    "feast/eider/adieu/seers/trust",
    "gaffs/adorn/folio/friar/snort",
    "astir/scone/tomes/inert/rests",
    "hawed/afire/widen/erect/dents",
    "barfs/axial/rifle/false/sleek",
    "pumps/uteri/medal/prank/silks",
    "prove/ripen/opine/venom/enema",
    "habit/arena/beset/inept/tatty",
    "gasps/annul/snore/purse/sleet",
    "abuts/besot/usage/togae/steel",
    "karat/aroma/rover/ameer/tarry",
    "valet/afire/linen/erect/tents",
    "mimes/ideal/metro/earls/slosh",
    "bulbs/uteri/lemur/brute/siren",
    "fared/alive/risen/event/dents",
    "zebus/enure/bulge/urged/seeds",
    "macaw/agate/cable/atlas/weest",
    "egret/glare/raven/erect/tenth",
    "curds/uteri/regal/draft/silts",
    "casts/alpha/speed/theme/sades",
    "magic/arena/genus/inure/cased",
    "clash/latte/attar/stand/herds",
    "muter/uvula/tunic/elide/racer",
    "barer/agile/ripen/elect/rents",
    "shrub/hyena/ready/undue/bayed",
    "munch/uvula/nuder/cleat/harts",
    "manor/ameba/newer/obese/rared",
    "hater/anode/toxic/edict/recta",
    "warns/abeam/reeve/naval/smell",
    "gelid/elite/liven/items/dense",
    "iambs/apart/maria/briar/stare",
    "penes/exude/nudge/edged/seedy",
    "drama/riled/alarm/merge/admen",
    "named/ameer/merry/eerie/dryer",
    "falls/await/later/liege/strep",
    "watch/aloha/tokes/chest/haste",
    "scats/caret/arena/tenor/stark",
    "asses/spent/sewer/enema/stray",
    "narcs/adore/rowel/creel/sells",
    "vests/equip/suede/tidal/spell",
    "wells/equal/lucre/large/sleep",
    "women/ovule/muses/elect/nests",
    "bleat/lemur/emote/autos/tress",
    "enema/nuder/edits/metro/arson",
    "lamas/apart/mange/argon/stent",
    "actor/clime/tiger/omega/reran",
    "pasty/aware/saris/tripe/yeses",
    "nasal/ample/spate/alter/leers",
    "twist/wench/inner/scene/threw",
    "hosts/octet/stone/tense/steer",
    "torts/opera/rebus/trues/sassy",
    "fills/idiot/lingo/logon/stony",
    "tacos/adult/curie/olive/steer",
    "dusts/ultra/stout/truce/sates",
    "rungs/uteri/newer/grebe/sires",
    "scalp/curie/arena/links/pease",
    "dales/abate/lathe/ether/seers",
    "wipes/inane/payed/enema/sedan",
    "lamps/abash/macho/pshaw/shown",
    "blank/login/agree/niece/kneel",
    "galas/alert/lever/arena/stray",
    "tarts/avail/ratty/title/slyer",
    "ester/stone/torus/enure/reset",
    "drums/reran/urine/manga/sneak",
    "shape/hulls/alias/plaza/essay",
    "comas/omega/merit/agile/sates",
    "parch/agile/river/cleat/hertz",
    "marsh/alike/river/skeet/hertz",
    "opine/penis/inset/niece/ester",
    "snows/nacho/ocher/where/sorer",
    "stows/three/organ/weals/sense",
    "dials/islet/alive/lever/stern",
    "ample/maria/press/lisle/eases",
    "mares/agent/retry/enrol/style",
    "damps/abort/movie/prism/stems",
    "scads/cadre/adman/drags/sense",
    "earls/await/rawer/liege/strep",
    "watts/aloha/tones/thees/sassy",
    "grove/ripen/opine/venom/enemy",
    "corps/overt/recur/prude/strep",
    "wreck/reran/erase/caste/kneed",
    "abate/baron/arena/tonic/enact",
    "whats/helot/aline/tonne/steep",
    "appal/phase/pasha/ashes/least",
    "discs/idiot/sigma/comas/stash",
    "harts/alarm/radii/trial/smile",
    "sorts/opera/resin/tribe/saner",
    "grave/ruled/along/venue/edges",
    "masts/altho/steel/theme/soled",
    "glass/light/agree/shear/stern",
    "foist/owner/inure/serve/treed",
    "rasps/alert/sepia/pricy/stays",
    "islet/spare/laces/erect/testy",
    "mocha/oboes/coons/henna/assay",
    "marts/aloha/rover/theme/saree",
    "limps/ideal/metro/pares/slosh",
    "tares/arena/rebel/enema/salad",
    "tamed/adore/mogul/erupt/delta",
    "fleas/linen/enure/aerie/sneer",
    "taste/ankhs/skies/theta/essay",
    "llama/legal/agent/manna/altar",
    "dress/remit/emcee/siege/steep",
    "avast/viler/alley/seems/tryst",
    "tangs/abort/novae/grape/steep",
    "clubs/lorry/urban/bravo/synod",
    "class/legit/agree/sieve/steed",
    "pasta/areas/setup/taupe/aspen",
    "haled/arena/least/ensue/dates",
    "fatty/afire/tipis/trite/yeses",
    "roved/opera/venal/erase/dales",
    "posed/ochre/shrub/erupt/debts",
    "bassi/arced/scope/sepia/ideas",
    "vocal/opine/cilia/anion/leans",
    "thees/halve/elbow/evoke/sewed",
    "brave/rotor/atria/voids/erase",
    "larch/afire/riser/credo/heron",
    "spume/papal/upend/manse/elder",
    "japan/alibi/piton/abort/ninth",
    "oases/adore/solar/erase/serer",
    "forth/opera/remit/trike/hated",
    "frost/route/outer/steps/terse",
    "yawls/aerie/wryer/liege/serer",
    "beard/eerie/argon/riots/dense",
    "olden/llano/dared/enema/nodal",
    "wants/adieu/nines/teeth/sushi",
    "track/reran/arise/caste/knees",
    "assay/slope/sorta/apter/years",
    "poppa/okras/press/paste/asses",
    "seals/endue/adore/lured/seedy",
    "tomes/ocean/merge/eagle/sneer",
    "ascot/slave/capon/ovoid/tends",
    "bauds/agree/urban/dears/sense",
    "gipsy/irate/papas/stake/yeses",
    "cards/adore/roman/drawn/senna",
    "pages/amino/gibed/enema/sodas",
    "pests/extra/stood/troll/sadly",
    "aglow/grave/label/overs/welsh",
    "amass/manic/anger/siege/screw",
    "cadge/aloha/donor/ghoul/earls",
    "papas/await/parse/aisle/steed",
    "saris/aware/radon/irons/sense",
    "yacht/alloy/clump/homie/typed",
    "tapes/afire/pilaw/erase/sewed",
    "kabob/aural/brute/oaths/bless",
    "bowel/ochre/whoop/erode/leper",
    "lodge/opera/decor/grout/earth",
    "sport/polar/oldie/raids/tress",
    "rates/abort/togae/erase/steer",
    "casks/achoo/sheaf/koala/sofas",
    "warts/aloha/royal/thaws/salsa",
    "start/three/aroma/remit/teats",
    "circa/ideal/rebut/cause/alter",
    "rawer/afire/wiles/erect/rests",
    "sumps/uteri/medal/prank/silks",
    "parka/adorn/robot/krone/antes",
    "beaus/exert/aerie/urine/steed",
    "mamas/abort/mover/arena/stray",
    "jeers/eyrie/erase/riser/seers",
    "cribs/radio/idyll/bilge/soles",
    "medic/ebony/dotes/inert/cysts",
    "whits/hovel/ivory/terse/slyer",
    "blest/loser/essay/seats/tryst",
    "shaft/hello/altar/flays/torsi",
    "sloop/larva/order/overt/parts",
    "acmes/cramp/mayor/emoji/sprig",
    "slams/labia/abets/mites/sassy",
    "rafts/adieu/fined/teens/sudsy",
    "sales/abide/liked/edema/sedan",
    "dowse/oared/wring/sense/edger",
    "saber/anode/borer/edema/reran",
    "heaps/exult/aurae/place/steel",
    "cramp/ruder/addle/melds/press",
    "pasts/abort/sonar/trace/strew",
    "catch/array/trope/capon/hyena",
    "tipsy/irate/papas/stage/yeses",
    "abaci/bacon/acing/condo/ingot",
    "sedan/exile/dicta/altar/nears",
    "lager/abide/given/edema/renal",
    "pride/riced/icing/dense/edged",
    "flora/loner/onset/reels/artsy",
    "paces/alarm/cameo/erect/smote",
    "wales/arena/least/ensue/sates",
    "rants/aloha/novel/theft/salts",
    "carom/aroma/rower/omens/marsh",
    "merit/elide/rifer/ideas/terse",
    "rehab/enema/helps/ample/based",
    "arena/rajas/eject/nacre/aster",
    "camps/acorn/movie/pride/sneer",
    "matts/afoul/torso/tusks/slosh",
    "decaf/erode/color/adorn/ferns",
    "asset/shire/sises/erect/tests",
    "usurp/sitar/uteri/rared/pride",
    "darts/avail/randy/tidal/slyly",
    "brash/recta/actor/stove/harem",
    "scrap/chive/rises/avert/pests",
    "amass/multi/allot/stone/sites",
    "stage/taped/aping/genre/edges",
    "isles/state/lathe/ether/seers",
    "osier/swore/iotas/erase/reset",
    "roads/octet/atria/deism/stamp",
    "least/error/argue/souse/treed",
    "crash/recta/actor/stows/harsh",
    "barbs/apart/radar/brave/strew",
    "eases/agent/septa/enter/stars",
    "males/aside/liege/edged/seeds",
    "image/mewed/awing/genre/edger",
    "ovals/vireo/aroma/lemur/soars",
    "racks/abort/color/krone/strep",
    "based/amuse/suite/ester/deers",
    "wadis/agent/delta/inter/stare",
    "carts/afire/riven/tread/sends",
    "cobra/oiled/blend/renal/addle",
    "fasts/aware/saree/trend/seeds",
    "woven/olive/vines/event/nests",
    "essay/slice/sigma/acmes/yeast",
    "doles/oxide/lived/edema/sedan",
    "peals/enrol/argue/louse/sleet",
    "smelt/molar/elate/latte/treed",
    "gofer/omega/feign/egged/randy",
    "large/axing/rigor/gnome/egret",
    "safer/afire/fines/erect/rests",
    "gaped/alive/pilot/evoke/deter",
    "crawl/rodeo/adman/weave/loner",
    "octet/chime/tibia/emirs/tease",
    "fades/abode/dosed/edema/sedan",
    "heats/extra/atlas/trams/sassy"
};

static void printsquare (char *square){
    int row;
    printf ("  1 2 3 4 5\n");
    for (row = 0; row < 5; ++row)
	printf
	    ("%d %c %c %c %c %c\n",
	     1 + row,
	     square[5 * row],
	     square[1 + 5 * row],
	     square[2 + 5 * row],
	     square[3 + 5 * row],
	     square[4 + 5 * row]);
}

static int squarecomplete (void)
{
    int c;
    for (c = 0; c < 25; ++c)
	if (yoursquare[c] < 'a' || yoursquare[c] > 'z') {
	    printf ("square must be completed to submit!\n");
	    return 0;
	}
    return 1;
}

static int choosesquare (void)
{
    int lineno,
	row,
	col;
    FILE *input;
    char linetext[32];
    srand (time (NULL));
    lineno = rand () % 365;
    strcpy (linetext, allsquares[lineno]);
    for (row = 0; row < 5; ++row)
	for (col = 0; col < 5; ++col) {
	    mysquare[col + 5 * row] = linetext[col + row * 6];
	    yoursquare[col + 5 * row]
		= (col == row || col == 4 - row)
		? linetext[col + row * 6]
		: '-';
	}
    return 0;
}

static int playturn (void)
{
    int wordno,
	letterno;
    char guess[81];
    printsquare (yoursquare);
    do {
	printf ("word (1-5): ");
	fgets (guess, sizeof(guess), stdin);
	wordno = atoi (guess);
	if (wordno == 0 && squarecomplete ())
	    return 0;
    } while (wordno < 1 || wordno > 5);
    --wordno;
    printf ("your guess: ");
    fgets (guess, sizeof(guess), stdin);
    guess[5] = '\0';
    if (strlen (guess) != 5)
	printf ("word must be 5 letters!\n");
    else if (guess[wordno] != yoursquare[wordno + 5 * wordno])
	printf
	    ("letter %d must be %c!\n",
	     1 + wordno,
	     yoursquare[wordno + 5 * wordno]);
    else if (guess[4 - wordno] != yoursquare[(4 - wordno) + 5 * wordno])
	printf
	    ("letter %d must be %c!\n",
	     5 - wordno,
	     yoursquare[(4 - wordno) + 5 * wordno]);
    else {
	for (letterno = 0; letterno < 5; ++letterno)
	    yoursquare[letterno + 5 * wordno]
		= yoursquare[wordno + 5 * letterno]
		= guess[letterno];
    }
    return 1;
}

static int checksquare (void)
{
    int row,
	col,
	correct[5],
	count = 0;
    for (row = 0; row < 5; ++row) {
	correct[row] = 1;
	for (col = 0; col < 5; ++col)
	    if (mysquare[col + 5 * row] != yoursquare[col + 5 * row])
		correct[row] = 0;
	count += correct[row];
    }
    if (count == 5) {
	printf ("Correct!\n");
	return 1;
    } else {
	for (row = 0; row < 5; ++row)
	    for (col = 0; col < 5; ++col)
		if (row == col || row == 4 - col);
		else if (correct[row] || correct[col]);
		else
		    yoursquare[col + 5 * row] = '-';
	printf ("Incorrect! %d/5 correct words.\n", count);
	return 0;
    }
}

static int initialise (void)
{
    int err;
    if ((err = choosesquare ()))
	return err;
    return 0;
}

static void playgame (void)
{
    printf
	("A word square consists of the same five words written\n"
	 "across and down.\n\n");
    printf
	("Fill in the word square by enteraing a word number\n"
	 "and your guess for that word, in lower case.\n"
	 "Once the square is full, press ENTER instead of a\n"
	 "word number to submit your guess.\n\n");
    printf ("To erase a word, re-enter it with hyphens in place\n"
	    "of the letters you want to erase.\n\n");
    do {
	while (playturn ());
    } while (! checksquare ());
}

static void finish (void)
{
}

int main (void)
{
    int err;
    if ((err = initialise ()))
	return err;
    playgame ();
    finish ();
    return 0;
}
