/*======================================================================
 * Pym's Daily Word Square Puzzle.
 * A puzzle game for MS-DOS.
 *
 * Copyright (C) Damian Gareth Walker 2024. Released under the GNU GPL.
 * Created: 20-Aug-2024.
 *
 * Main header.
 */

#ifndef __PYM_H__
#define __PYM_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/* required headers */
#include "controls.h"
#include "display.h"
#include "calendar.h"
#include "game.h"

/*----------------------------------------------------------------------
 * Public Level Routines.
 */

/**
 * Share the control handler with other modules.
 * @return A pointer to the game control handler.
 */
Controls *getcontrols (void);

/**
 * Share the display handler with other modules.
 * @return A pointer to the display module.
 */
Display *getdisplay (void);

/**
 * Share the calendar handler with other modules.
 * @return A pointer to the calendar object.
 */
Calendar *getcalendar (void);

/**
 * Share the game handler with other modules.
 * @return A pointer to the game object.
 */
Game *getgame (void);

#endif
