/*======================================================================
 * Pym's Daily Word Square Puzzle.
 * A puzzle game for MS-DOS.
 *
 * Copyright (C) Damian Gareth Walker 2024. Released under the GNU GPL.
 * Created: 24-Aug-2024.
 *
 * UI Header.
 */


/* types defined in this header. */
typedef struct ui UI;

#ifndef __UI_H__
#define __UI_H__

/*----------------------------------------------------------------------
 * Data Definitions.
 */

/**
 * @struct ui The basic user interface.
 */
struct ui {

    /*
     * Methods
     */

    /**
     * Destroy UI.
     */
    void (*destroy) (void);

    /**
     * Initialise the UI.
     * @return   1 on success, 0 on failure.
     */
    int (*init) (void);

    /**
     * Operate the UI.
     * @return   1 on success, 0 on failure.
     */
    int (*operate) (void);

};

/*----------------------------------------------------------------------
 * Top Level Function Declarations.
 */

/**
 * Construct Generic UI.
 * @return The new UI.
 */
UI *new_UI (void);

/**
 * Construct Puzzle UI
 * @return The new UI.
 */
UI *new_PuzzleUI (void);

/**
 * Construct Calendar UI
 * @return The new UI.
 */
UI *new_CalendarUI (void);

#endif
