//======================================================================
// Pym's Daily Word Square Puzzle.
// A puzzle game for MS-DOS.
//
// Copyright (C) Damian Gareth Walker 2024. Released under the GNU GPL.
// Created: 01-Nov-2024.
//
// Book Definition.
//

#include "fabric.inc"

// Book Cover Board
#declare BookCoverBoard =
box {
  <-0.1, -10, -6.25>
  <0.1, 10, 6.25>
}

// Book Spine
#declare BookSpine =
difference {
  cylinder {
    <0, -10, 0>,
    <0, 10, 0>
    1.1
    scale <1, 1, 0.2>
  }
  cylinder {
    <0, -10, 0>,
    <0, 10, 0>
    0.9
    scale <1, 1, 0.2>
  }
  box {
    <-1.1, -10, 0>
    <1.1, 10, 1.21>
  }
}

// Book Cover
#declare BookCover =
union {
  object {
    BookSpine
    translate <0, 0, -6.25>
  }
  object {
    BookCoverBoard
    translate <-1, 0, 0>
  }
  object {
    BookCoverBoard
    translate <1, 0, 0>
  }
  texture {
    fabric
    pigment {
      color rgb <1, 0, 0>
    }
  }
}

// Book Paper
#declare BookPaper =
union {
  box {
    <-0.9, -9.5, -6.25>
    <0.9, 9.5, 6>
  }
  cylinder {
    <0, -9.5, 0>,
    <0, 9.5, 0>
    0.9
    scale <1, 1, 0.2>
    translate <0, 0, -6.25>
  }
  texture {
    pigment {
      color rgb <1, 1, 1>
    }
  }
}

#declare Book =
union {
  object { BookCover }
  object { BookPaper }
}

#declare BlueBook =
union {
  object {
    BookCover
    texture {
      fabric
      pigment {
        color rgb <0, 0, 1>
      }
    }
  }
  object { BookPaper }
}

#declare GreenBook =
union {
  object {
    BookCover
    texture {
      fabric
      pigment {
        color rgb <0, 1, 0>
      }
    }
  }
  object { BookPaper }
}

#declare BrownBook =
union {
  object {
    BookCover
    texture {
      fabric
      pigment {
        color rgb <0.66, 0.33, 0>
      }
    }
  }
  object { BookPaper }
}